<?php defined('BASEPATH') or exit('No direct script access allowed');
class Income_m extends CI_Model
{
    public function getIncome($income_id = null)
    {
        $this->db->select('*');
        $this->db->from('income');
        if ($income_id != null) {
            $this->db->where('$income_id', $income_id);
        }
        $this->db->order_by('date_payment', 'DESC');
        $query = $this->db->get();
        return $query;
    }
    public function getIncomeThisMonth()
    {
        $this->db->select('*');
        $this->db->from('income');
        $this->db->where('MONTH(date_payment)', date('m'));
        $this->db->where('YEAR(date_payment)', date('Y'));
        if ($this->session->userdata('role_id') == 3) {
            $this->db->where('create_by', $this->session->userdata('id'));
        }
        $query = $this->db->get();
        return $query;
    }
    public function getIncomeJan()
    {
        $this->db->select('*');
        $this->db->from('income');
        $this->db->where('MONTH(date_payment)', '01');
        $this->db->where('YEAR(date_payment)', date('Y'));
        $query = $this->db->get();
        return $query;
    }
    public function getIncomeFeb()
    {
        $this->db->select('*');
        $this->db->from('income');
        $this->db->where('MONTH(date_payment)', '02');
        $this->db->where('YEAR(date_payment)', date('Y'));
        $query = $this->db->get();
        return $query;
    }
    public function getIncomeMar()
    {
        $this->db->select('*');
        $this->db->from('income');
        $this->db->where('MONTH(date_payment)', '03');
        $this->db->where('YEAR(date_payment)', date('Y'));
        $query = $this->db->get();
        return $query;
    }
    public function getIncomeApr()
    {
        $this->db->select('*');
        $this->db->from('income');
        $this->db->where('MONTH(date_payment)', '04');
        $this->db->where('YEAR(date_payment)', date('Y'));
        $query = $this->db->get();
        return $query;
    }
    public function getIncomeMay()
    {
        $this->db->select('*');
        $this->db->from('income');
        $this->db->where('MONTH(date_payment)', '05');
        $this->db->where('YEAR(date_payment)', date('Y'));
        $query = $this->db->get();
        return $query;
    }
    public function getIncomeJun()
    {
        $this->db->select('*');
        $this->db->from('income');
        $this->db->where('MONTH(date_payment)', '06');
        $this->db->where('YEAR(date_payment)', date('Y'));
        $query = $this->db->get();
        return $query;
    }
    public function getIncomeJul()
    {
        $this->db->select('*');
        $this->db->from('income');
        $this->db->where('MONTH(date_payment)', '07');
        $this->db->where('YEAR(date_payment)', date('Y'));
        $query = $this->db->get();
        return $query;
    }
    public function getIncomeAug()
    {
        $this->db->select('*');
        $this->db->from('income');
        $this->db->where('MONTH(date_payment)', '08');
        $this->db->where('YEAR(date_payment)', date('Y'));
        $query = $this->db->get();
        return $query;
    }
    public function getIncomeSep()
    {
        $this->db->select('*');
        $this->db->from('income');
        $this->db->where('MONTH(date_payment)', '09');
        $this->db->where('YEAR(date_payment)', date('Y'));
        $query = $this->db->get();
        return $query;
    }
    public function getIncomeOct()
    {
        $this->db->select('*');
        $this->db->from('income');
        $this->db->where('MONTH(date_payment)', '10');
        $this->db->where('YEAR(date_payment)', date('Y'));
        $query = $this->db->get();
        return $query;
    }
    public function getIncomeNov()
    {
        $this->db->select('*');
        $this->db->from('income');
        $this->db->where('MONTH(date_payment)', '11');
        $this->db->where('YEAR(date_payment)', date('Y'));
        $query = $this->db->get();
        return $query;
    }
    public function getIncomeDec()
    {
        $this->db->select('*');
        $this->db->from('income');
        $this->db->where('MONTH(date_payment)', '12');
        $this->db->where('YEAR(date_payment)', date('Y'));
        $query = $this->db->get();
        return $query;
    }
    public function addPayment($post)
    {
        $params = [
            'nominal' => $post['nominal'],
            'date_payment' => $post['date_payment'],
            'invoice_id' => $post['invoice'],
            'no_services' => $post['no_services'],
            'category' => 1,
            'create_by' => $this->session->userdata('id'),
            'remark' => 'Pembayaran Tagihan no layanan' . ' ' . $post['no_services'] . ' ' . 'a/n' . ' ' . $post['name'] . ' ' . 'Periode' . ' ' . $post['month'] . ' ' . $post['year'],
            'created' => time()
        ];
        $this->db->insert('income', $params);
    }
    public function addPaymentFast($post)
    {
        $params = [
            'nominal' => $post['nominal'],
            'date_payment' => date('Y-m-d'),
            'invoice_id' => $post['invoice'],
            'no_services' => $post['no_services'],
            'create_by' => $this->session->userdata('id'),
            'category' => 1,
            'remark' => 'Pembayaran Tagihan no layanan' . ' ' . $post['no_services'] . ' ' . 'a/n' . ' ' . $post['name'] . ' ' . 'Periode' . ' ' . $post['month'] . ' ' . $post['year'],
            'created' => time()
        ];
        $this->db->insert('income', $params);
    }
    public function addbymidtrans($result)
    {
        $invoice = $this->db->get_where('invoice', ['order_id' => $result['order_id']])->row_array();
        $customer = $this->db->get_where('customer', ['no_services' => $invoice['no_services']])->row_array();
        $params = [
            'nominal' => $result['gross_amount'],
            'date_payment' => date('Y-m-d'),
            'remark' => 'Pembayaran Tagihan no layanan' . ' ' . $invoice['no_services'] . ' ' . 'a/n' . ' ' . $customer['name'] . ' ' . 'Periode' . ' ' . indo_month($invoice['month']) . ' ' . $invoice['year'] . ' by Midtrans',
            'invoice_id' => $invoice['invoice'],
            'no_services' => $invoice['no_services'],
            'mode_payment' => 'Midtrans',
            'category' => 1,
            'created' => time()
        ];
        $this->db->insert('income', $params);
    }

    public function add($post)
    {
        $params = [
            'nominal' => $post['nominal'],
            'category' => $post['category'],
            'date_payment' => htmlspecialchars($post['date_payment']),
            'remark' => htmlspecialchars($post['remark']),
            'created' => time()
        ];
        $this->db->insert('income', $params);
    }
    public function edit($post)
    {
        $params = [
            'nominal' => $post['nominal'],
            'category' => $post['category'],
            'date_payment' => htmlspecialchars($post['date_payment']),
            'remark' => htmlspecialchars($post['remark']),
        ];
        $this->db->where('income_id',  $post['income_id']);
        $this->db->update('income', $params);
    }

    public function delete($income_id)
    {
        $this->db->where('income_id', $income_id);
        $this->db->delete('income');
    }

    public function getFilter($post)
    {
        $this->db->select('*');
        $this->db->from('income');
        if (!empty($post['tanggal']) && !empty($post['tanggal2'])) {
            $this->db->where("income.date_payment BETWEEN '" . ($post['tanggal']) . "' AND '" . ($post['tanggal2']) . "'");
        }
        $this->db->order_by('date_payment', 'ASC');
        $query = $this->db->get();
        return $query;
    }

    // XENDIT
    public function addbyxendit($ext_id)
    {
        $invoice = $this->db->get_where('invoice', ['x_external_id' => $ext_id])->row_array();
        $customer = $this->db->get_where('customer', ['no_services' => $invoice['no_services']])->row_array();
        $params = [
            'nominal' => $invoice['amount'],
            'date_payment' => date('Y-m-d'),
            'remark' => 'Pembayaran Tagihan no layanan' . ' ' . $invoice['no_services'] . ' ' . 'a/n' . ' ' . $customer['name'] . ' ' . 'Periode' . ' ' . indo_month($invoice['month']) . ' ' . $invoice['year'] . ' by Xendit',
            'invoice_id' => $invoice['invoice'],
            'category' => 1,
            'no_services' => $invoice['no_services'],
            'mode_payment' => 'XENDIT',
            'created' => time()
        ];
        $this->db->insert('income', $params);
    }
    public function payselected($params)
    {
        $this->db->insert_batch('income', $params);
    }
    public function incomeselected($invoice = null)
    {

        $this->db->from('income');
        $this->db->where_in('invoice_id', $invoice);
        $this->db->order_by('date_payment', 'DESC');
        $query = $this->db->get();
        return $query;
    }

    public function deleteselected($income_id)
    {
        $this->db->where_in('income_id', $income_id);
        $this->db->delete('income');
    }
    public function getFilterColector($post)
    {
        $this->db->select('*');
        $this->db->from('income');
        if (!empty($post['tanggal']) && !empty($post['tanggal2'])) {
            $this->db->where("income.date_payment BETWEEN '" . ($post['tanggal']) . "' AND '" . ($post['tanggal2']) . "'");
        }
        $this->db->where('create_by',  $post['user_id']);
        $this->db->order_by('date_payment', 'ASC');
        $query = $this->db->get();
        return $query;
    }

    public function getFilterMonth($post)
    {
        $this->db->select('*');
        $this->db->from('income');
        $this->db->where('MONTH(date_payment)', $post['month']);
        $this->db->where('YEAR(date_payment)', $post['year']);
        $this->db->order_by('date_payment', 'ASC');
        $query = $this->db->get();
        return $query;
    }
    // KATEGORI
    public function getcategory($category_id = null)
    {
        $this->db->select('*');
        $this->db->from('cat_income');
        if ($category_id != null) {
            $this->db->where('category_id', $category_id);
        }
        $this->db->order_by('name', 'ASC');
        $query = $this->db->get();
        return $query;
    }
    public function addcategory($post)
    {
        $params = [
            'name' => $post['name'],
            'remark' => htmlspecialchars($post['remark']),
        ];
        $this->db->insert('cat_income', $params);
    }
    public function editcategory($post)
    {
        $params = [
            'name' => $post['name'],

            'remark' => htmlspecialchars($post['remark']),
        ];
        $this->db->where('category_id',  $post['category_id']);
        $this->db->update('cat_income', $params);
    }
    public function deletecategory($category_id)
    {
        $this->db->where('category_id', $category_id);
        $this->db->delete('cat_income');
    }
    // SERVER SIDE
    private function _get_data_query()
    {
        $this->db->select('*');
        $this->db->from('income');
        if (isset($_POST['search']['value'])) {
            $this->db->like('date_payment', $_POST['search']['value']);
            $this->db->or_like('nominal', $_POST['search']['value']);
            $this->db->or_like('remark', $_POST['search']['value']);
        }

        if (isset($_POST['order'])) {
            $this->db->order_by($this->order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
        } else {
            $this->db->order_by('date_payment', 'Desc');
        }
    }
    public function getDataInc()
    {
        $this->_get_data_query();
        if ($_POST['lengt'] != -1) {
            $this->db->limit($_POST['length'], $_POST['start']);
        }
        $query = $this->db->get();
        return $query->result();
    }

    public function count_filtered_data()
    {
        $this->_get_data_query();
        $query = $this->db->get();
        return $query->num_rows();
    }

    public function count_all_data()
    {
        $this->db->from($this->table);
        return $this->db->count_all_results();
    }
}
